<?php
	wp_enqueue_style('all-posr-style', wp_iv_directories_URLPATH . 'admin/files/css/all-post.css');
	wp_enqueue_style('jquery.dataTables', wp_iv_directories_URLPATH . 'admin/files/css/jquery.dataTables.css');
	wp_enqueue_script('jquery.dataTables', wp_iv_directories_URLPATH . 'admin/files/js/jquery.dataTables.js');
	$profile_url=get_permalink();
	global $current_user;
	$user = $current_user->ID;
	$message='';
	if(isset($_GET['delete_id']))  {
		$post_id=sanitize_text_field($_GET['delete_id']);
		$post_edit = get_post($post_id);
		if($post_edit->post_author==$current_user->ID){
			wp_delete_post($post_id);
			delete_post_meta($post_id,true);
			$message=esc_html__( 'Deleted Successfully', 'ivdirectories' );
			}else{
			if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
				wp_delete_post($post_id);
				delete_post_meta($post_id,true);
				$message=esc_html__( 'Deleted Successfully', 'ivdirectories' );
			}
		}
	}	
?>
<div class="profile-content">
	<div class="portlet light">
		<div class="portlet-title tabbable-line clearfix">
			<div class="caption caption-md">
				<span class="caption-subject">
					<?php
						esc_html_e('All Listing','ivdirectories');
						$default_post_type = array();
						$default_fields= array();
						$postkey= array();
						$post_set=get_option('_iv_directory_url_postype' );
						if($post_set!=""){
							$default_fields=get_option('_iv_directory_url_postype' );
							}else{
							$default_fields['hotel']='Hotel';
							$default_fields['restaurant']='Restaurant';
							$default_fields['bar']='Bar';	
						}
						foreach($default_fields as $key => $value)
						{
							$postkey[] = $key;
						}
						$post_type = join("','",$postkey);
					?></span>
			</div>
		</div>
		<div class="row">
			<?php
				foreach($default_fields as $key => $value)
				{
				?><div class="col-md-3">
				<a href="<?php echo get_post_type_archive_link($key); ?>" class="btn green-haze" ><?php echo esc_html($value); esc_html_e(' Home','ivdirectories'); ?></a>
				</div>
				<?php
				}
			?>
		</div>
		<?php
			if($message!=''){
				echo  '<div class="alert alert-info alert-dismissable"><a class="panel-close close" data-dismiss="alert">x</a>'.esc_html($message).'.</div>';
			}
		?>
		<div class="table-responsive listing-table">
			<?php
				global $wpdb;
				$per_page=10;$row_strat=0;$row_end=$per_page;
				$current_page=0 ;
				if(isset($_REQUEST['cpage']) and $_REQUEST['cpage']!=1 ){
					$current_page=$_REQUEST['cpage']; $row_strat =($current_page-1)*$per_page;
					$row_end=$per_page;
				}
				if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
					
					$sql="SELECT * FROM $wpdb->posts WHERE post_type IN ('$post_type')  and post_status IN ('publish','pending','draft' )  ORDER BY `ID` DESC";
					}else{
					$sql=$wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_type IN ('$post_type')  and post_author='%d' and post_status IN ('publish','pending','draft' )  ORDER BY `ID` DESC",$current_user->ID );
				}
				$authpr_post = $wpdb->get_results($sql);
				
				$total_post=count($authpr_post);
				if($total_post>0){
				?>
				<table id="user-data-all" class="display table" cellspacing="0" width="100%">
					<thead>
						
						<tr class="">
							<th><?php  esc_html_e('ID','ivdirectories');?></th>
							<th><?php  esc_html_e('Title','ivdirectories');?></th>
							<th><?php  esc_html_e('Type','ivdirectories');?></th>
							<th><?php  esc_html_e('Expire','ivdirectories');?></th>
							<th><?php  esc_html_e('Status','ivdirectories');?></th>
							<th><?php  esc_html_e('Actions','ivdirectories');?></th>
						</tr>
					</thead>
					<?php
						$i=0;
						foreach ( $authpr_post as $row )
						{
						?>
						<tr>
							<td> <?php echo esc_html($row->ID); ?></td>
							<td style="">
								<a class="profile-desc-link" href="<?php echo get_permalink($row->ID); ?>" >
									<?php
										// Get latlng from address* START********
										$dir_lat=get_post_meta($row->ID,'latitude',true);
										$dir_lng=get_post_meta($row->ID,'longitude',true);
										$address = get_post_meta($row->ID, 'address', true);
										if($address!=''){
											if($dir_lat=='' || $dir_lng==''){
												$latitude='';$longitude='';
												$prepAddr = str_replace(' ','+',$address);
												$geocode=wp_remote_fopen('http://maps.google.com/maps/api/geocode/json?address='.$prepAddr.'&sensor=false');
												$output= json_decode($geocode);
												if(isset( $output->results[0]->geometry->location->lat)){
													$latitude = $output->results[0]->geometry->location->lat;
												}
												if(isset($output->results[0]->geometry->location->lng)){
													$longitude = $output->results[0]->geometry->location->lng;
												}
												if($latitude!=''){
													update_post_meta($row->ID,'latitude',$latitude);
												}
												if($longitude!=''){
													update_post_meta($row->ID,'longitude',$longitude);
												}
											}
										}
										// Get latlng from address* ENDDDDDD********
									?>
								<?php echo esc_html($row->post_title); ?></a>
							</td>
							<td  class="font14">
								<?php echo  esc_html($row->post_type); ?>
							</td>
							<td class="font14">
								<?php
									$exp_date= get_user_meta($current_user->ID, 'iv_directories_exprie_date', true);
									if($exp_date!=''){
										$package_id=get_user_meta($current_user->ID,'iv_directories_package_id',true);
										$dir_hide= get_post_meta($package_id, 'iv_directories_package_hide_exp', true);
										if($dir_hide=='yes'){
											echo date('d-M-Y',strtotime($exp_date));
										}
									}
								?>
							</td>
							<td  class="font14"><?php echo get_post_status( $row->ID ) ?></td>
							<td >
								<?php
									$edit_post= $profile_url.'?&profile=listing-edit&post-id='.$row->ID;
								?>
								<a href="<?php echo esc_html($edit_post); ?>" class="btn btn-xs green-haze" ><?php esc_html_e('Edit','ivdirectories'); ?></a>
								<a href="<?php echo esc_html($profile_url).'?&profile=all-post&delete_id='.esc_html($row->ID) ;?>"  onclick="return confirm('Are you sure to delete this post?');"  class="btn btn-xs btn-danger"><?php esc_html_e('Delete','ivdirectories'); ?>
								</a></td>
						</tr>
						<?php
						}
					?>
				</table>
				<?php
					}else{
				?>
				<table>
					<tr>
						<td colspan="100%">
							<?php esc_html_e('Currently you have no listings added. Please manage your account from the sidebar on the left.','ivdirectories'); ?>
						</td>
					</tr>
				</table>
				<?php
				}
			?>
		</div>
	</div>
</div>